/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWebAclRequest extends WafRequest implements
        ToCopyableBuilder<CreateWebAclRequest.Builder, CreateWebAclRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWebAclRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWebAclRequest::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<WafAction> DEFAULT_ACTION_FIELD = SdkField.<WafAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateWebAclRequest::defaultAction)).setter(setter(Builder::defaultAction))
            .constructor(WafAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWebAclRequest::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateWebAclRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, METRIC_NAME_FIELD,
            DEFAULT_ACTION_FIELD, CHANGE_TOKEN_FIELD, TAGS_FIELD));

    private final String name;

    private final String metricName;

    private final WafAction defaultAction;

    private final String changeToken;

    private final List<Tag> tags;

    private CreateWebAclRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.defaultAction = builder.defaultAction;
        this.changeToken = builder.changeToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A friendly name or description of the <a>WebACL</a>. You can't change <code>Name</code> after you create the
     * <code>WebACL</code>.
     * </p>
     * 
     * @return A friendly name or description of the <a>WebACL</a>. You can't change <code>Name</code> after you create
     *         the <code>WebACL</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only
     * alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
     * whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change
     * <code>MetricName</code> after you create the <code>WebACL</code>.
     * </p>
     * 
     * @return A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only
     *         alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
     *         whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change
     *         <code>MetricName</code> after you create the <code>WebACL</code>.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of the
     * <code>Rule</code> objects that are associated with the <code>WebACL</code>.
     * </p>
     * 
     * @return The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of
     *         the <code>Rule</code> objects that are associated with the <code>WebACL</code>.
     */
    public WafAction defaultAction() {
        return defaultAction;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to <a>GetChangeToken</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebAclRequest)) {
            return false;
        }
        CreateWebAclRequest other = (CreateWebAclRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(defaultAction(), other.defaultAction()) && Objects.equals(changeToken(), other.changeToken())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateWebAclRequest").add("Name", name()).add("MetricName", metricName())
                .add("DefaultAction", defaultAction()).add("ChangeToken", changeToken()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultAction()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebAclRequest, T> g) {
        return obj -> g.apply((CreateWebAclRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWebAclRequest> {
        /**
         * <p>
         * A friendly name or description of the <a>WebACL</a>. You can't change <code>Name</code> after you create the
         * <code>WebACL</code>.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the <a>WebACL</a>. You can't change <code>Name</code> after you
         *        create the <code>WebACL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only
         * alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain
         * whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change
         * <code>MetricName</code> after you create the <code>WebACL</code>.
         * </p>
         * 
         * @param metricName
         *        A friendly name or description for the metrics for this <code>WebACL</code>.The name can contain only
         *        alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't
         *        contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You
         *        can't change <code>MetricName</code> after you create the <code>WebACL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of the
         * <code>Rule</code> objects that are associated with the <code>WebACL</code>.
         * </p>
         * 
         * @param defaultAction
         *        The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of
         *        the <code>Rule</code> objects that are associated with the <code>WebACL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAction(WafAction defaultAction);

        /**
         * <p>
         * The action that you want AWS WAF to take when a request doesn't match the criteria specified in any of the
         * <code>Rule</code> objects that are associated with the <code>WebACL</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link WafAction.Builder} avoiding the need to create
         * one manually via {@link WafAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link WafAction.Builder#build()} is called immediately and its result
         * is passed to {@link #defaultAction(WafAction)}.
         * 
         * @param defaultAction
         *        a consumer that will call methods on {@link WafAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAction(WafAction)
         */
        default Builder defaultAction(Consumer<WafAction.Builder> defaultAction) {
            return defaultAction(WafAction.builder().applyMutation(defaultAction).build());
        }

        /**
         * <p>
         * The value returned by the most recent call to <a>GetChangeToken</a>.
         * </p>
         * 
         * @param changeToken
         *        The value returned by the most recent call to <a>GetChangeToken</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WafRequest.BuilderImpl implements Builder {
        private String name;

        private String metricName;

        private WafAction defaultAction;

        private String changeToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebAclRequest model) {
            super(model);
            name(model.name);
            metricName(model.metricName);
            defaultAction(model.defaultAction);
            changeToken(model.changeToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final WafAction.Builder getDefaultAction() {
            return defaultAction != null ? defaultAction.toBuilder() : null;
        }

        @Override
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(WafAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebAclRequest build() {
            return new CreateWebAclRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
