/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleGroupResponse extends WafResponse implements
        ToCopyableBuilder<CreateRuleGroupResponse.Builder, CreateRuleGroupResponse> {
    private static final SdkField<RuleGroup> RULE_GROUP_FIELD = SdkField.<RuleGroup> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateRuleGroupResponse::ruleGroup)).setter(setter(Builder::ruleGroup))
            .constructor(RuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroup").build()).build();

    private static final SdkField<String> CHANGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRuleGroupResponse::changeToken)).setter(setter(Builder::changeToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_GROUP_FIELD,
            CHANGE_TOKEN_FIELD));

    private final RuleGroup ruleGroup;

    private final String changeToken;

    private CreateRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.ruleGroup = builder.ruleGroup;
        this.changeToken = builder.changeToken;
    }

    /**
     * <p>
     * An empty <a>RuleGroup</a>.
     * </p>
     * 
     * @return An empty <a>RuleGroup</a>.
     */
    public RuleGroup ruleGroup() {
        return ruleGroup;
    }

    /**
     * <p>
     * The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can also use
     * this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
     * </p>
     * 
     * @return The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can
     *         also use this value to query the status of the request. For more information, see
     *         <a>GetChangeTokenStatus</a>.
     */
    public String changeToken() {
        return changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(changeToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleGroupResponse)) {
            return false;
        }
        CreateRuleGroupResponse other = (CreateRuleGroupResponse) obj;
        return Objects.equals(ruleGroup(), other.ruleGroup()) && Objects.equals(changeToken(), other.changeToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRuleGroupResponse").add("RuleGroup", ruleGroup()).add("ChangeToken", changeToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleGroup":
            return Optional.ofNullable(clazz.cast(ruleGroup()));
        case "ChangeToken":
            return Optional.ofNullable(clazz.cast(changeToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleGroupResponse, T> g) {
        return obj -> g.apply((CreateRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleGroupResponse> {
        /**
         * <p>
         * An empty <a>RuleGroup</a>.
         * </p>
         * 
         * @param ruleGroup
         *        An empty <a>RuleGroup</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroup(RuleGroup ruleGroup);

        /**
         * <p>
         * An empty <a>RuleGroup</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleGroup.Builder} avoiding the need to create
         * one manually via {@link RuleGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroup.Builder#build()} is called immediately and its result
         * is passed to {@link #ruleGroup(RuleGroup)}.
         * 
         * @param ruleGroup
         *        a consumer that will call methods on {@link RuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroup(RuleGroup)
         */
        default Builder ruleGroup(Consumer<RuleGroup.Builder> ruleGroup) {
            return ruleGroup(RuleGroup.builder().applyMutation(ruleGroup).build());
        }

        /**
         * <p>
         * The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can also
         * use this value to query the status of the request. For more information, see <a>GetChangeTokenStatus</a>.
         * </p>
         * 
         * @param changeToken
         *        The <code>ChangeToken</code> that you used to submit the <code>CreateRuleGroup</code> request. You can
         *        also use this value to query the status of the request. For more information, see
         *        <a>GetChangeTokenStatus</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeToken(String changeToken);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private RuleGroup ruleGroup;

        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleGroupResponse model) {
            super(model);
            ruleGroup(model.ruleGroup);
            changeToken(model.changeToken);
        }

        public final RuleGroup.Builder getRuleGroup() {
            return ruleGroup != null ? ruleGroup.toBuilder() : null;
        }

        @Override
        public final Builder ruleGroup(RuleGroup ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        public final void setRuleGroup(RuleGroup.BuilderImpl ruleGroup) {
            this.ruleGroup = ruleGroup != null ? ruleGroup.build() : null;
        }

        public final String getChangeToken() {
            return changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public CreateRuleGroupResponse build() {
            return new CreateRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
