/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.transform.RegexPatternSetUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegexPatternSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, RegexPatternSetUpdate> {
    private final String action;
    private final String regexPatternString;

    private RegexPatternSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.regexPatternString = builder.regexPatternString;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public String regexPatternString() {
        return this.regexPatternString;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSetUpdate)) {
            return false;
        }
        RegexPatternSetUpdate other = (RegexPatternSetUpdate)obj;
        return Objects.equals(this.actionString(), other.actionString()) && Objects.equals(this.regexPatternString(), other.regexPatternString());
    }

    public String toString() {
        return ToString.builder((String)"RegexPatternSetUpdate").add("Action", (Object)this.actionString()).add("RegexPatternString", (Object)this.regexPatternString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "RegexPatternString": {
                return Optional.of(clazz.cast(this.regexPatternString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegexPatternSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String regexPatternString;

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSetUpdate model) {
            this.action(model.action);
            this.regexPatternString(model.regexPatternString);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRegexPatternString() {
            return this.regexPatternString;
        }

        @Override
        public final Builder regexPatternString(String regexPatternString) {
            this.regexPatternString = regexPatternString;
            return this;
        }

        public final void setRegexPatternString(String regexPatternString) {
            this.regexPatternString = regexPatternString;
        }

        public RegexPatternSetUpdate build() {
            return new RegexPatternSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegexPatternSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder regexPatternString(String var1);
    }
}

