/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.SqlInjectionMatchSetUpdatesCopier;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateSqlInjectionMatchSetRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, UpdateSqlInjectionMatchSetRequest> {
    private final String sqlInjectionMatchSetId;
    private final String changeToken;
    private final List<SqlInjectionMatchSetUpdate> updates;

    private UpdateSqlInjectionMatchSetRequest(BuilderImpl builder) {
        super(builder);
        this.sqlInjectionMatchSetId = builder.sqlInjectionMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String sqlInjectionMatchSetId() {
        return this.sqlInjectionMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<SqlInjectionMatchSetUpdate> updates() {
        return this.updates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlInjectionMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSqlInjectionMatchSetRequest)) {
            return false;
        }
        UpdateSqlInjectionMatchSetRequest other = (UpdateSqlInjectionMatchSetRequest)((Object)obj);
        return Objects.equals(this.sqlInjectionMatchSetId(), other.sqlInjectionMatchSetId()) && Objects.equals(this.changeToken(), other.changeToken()) && Objects.equals(this.updates(), other.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sqlInjectionMatchSetId() != null) {
            sb.append("SqlInjectionMatchSetId: ").append(this.sqlInjectionMatchSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlInjectionMatchSetId": {
                return Optional.of(clazz.cast(this.sqlInjectionMatchSetId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
            case "Updates": {
                return Optional.of(clazz.cast(this.updates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String sqlInjectionMatchSetId;
        private String changeToken;
        private List<SqlInjectionMatchSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSqlInjectionMatchSetRequest model) {
            this.sqlInjectionMatchSetId(model.sqlInjectionMatchSetId);
            this.changeToken(model.changeToken);
            this.updates(model.updates);
        }

        public final String getSqlInjectionMatchSetId() {
            return this.sqlInjectionMatchSetId;
        }

        @Override
        public final Builder sqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
            return this;
        }

        public final void setSqlInjectionMatchSetId(String sqlInjectionMatchSetId) {
            this.sqlInjectionMatchSetId = sqlInjectionMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<SqlInjectionMatchSetUpdate.Builder> getUpdates() {
            return this.updates != null ? (Collection)this.updates.stream().map(SqlInjectionMatchSetUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updates(Collection<SqlInjectionMatchSetUpdate> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(SqlInjectionMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<SqlInjectionMatchSetUpdate.BuilderImpl> updates) {
            this.updates = SqlInjectionMatchSetUpdatesCopier.copyFromBuilder(updates);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateSqlInjectionMatchSetRequest build() {
            return new UpdateSqlInjectionMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, UpdateSqlInjectionMatchSetRequest> {
        public Builder sqlInjectionMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<SqlInjectionMatchSetUpdate> var1);

        public Builder updates(SqlInjectionMatchSetUpdate ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

