/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.HTTPRequest;
import software.amazon.awssdk.services.waf.transform.SampledHTTPRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SampledHTTPRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, SampledHTTPRequest> {
    private final HTTPRequest request;
    private final Long weight;
    private final Instant timestamp;
    private final String action;

    private SampledHTTPRequest(BuilderImpl builder) {
        this.request = builder.request;
        this.weight = builder.weight;
        this.timestamp = builder.timestamp;
        this.action = builder.action;
    }

    public HTTPRequest request() {
        return this.request;
    }

    public Long weight() {
        return this.weight;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public String action() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.request());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampledHTTPRequest)) {
            return false;
        }
        SampledHTTPRequest other = (SampledHTTPRequest)obj;
        return Objects.equals(this.request(), other.request()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.action(), other.action());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.request() != null) {
            sb.append("Request: ").append(this.request()).append(",");
        }
        if (this.weight() != null) {
            sb.append("Weight: ").append(this.weight()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Request": {
                return Optional.of(clazz.cast(this.request()));
            }
            case "Weight": {
                return Optional.of(clazz.cast(this.weight()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.action()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SampledHTTPRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private HTTPRequest request;
        private Long weight;
        private Instant timestamp;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(SampledHTTPRequest model) {
            this.request(model.request);
            this.weight(model.weight);
            this.timestamp(model.timestamp);
            this.action(model.action);
        }

        public final HTTPRequest.Builder getRequest() {
            return this.request != null ? this.request.toBuilder() : null;
        }

        @Override
        public final Builder request(HTTPRequest request) {
            this.request = request;
            return this;
        }

        public final void setRequest(HTTPRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        public final Long getWeight() {
            return this.weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public SampledHTTPRequest build() {
            return new SampledHTTPRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SampledHTTPRequest> {
        public Builder request(HTTPRequest var1);

        default public Builder request(Consumer<HTTPRequest.Builder> request) {
            return this.request((HTTPRequest)((HTTPRequest.Builder)HTTPRequest.builder().apply(request)).build());
        }

        public Builder weight(Long var1);

        public Builder timestamp(Instant var1);

        public Builder action(String var1);
    }
}

