/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteWebACLRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, DeleteWebACLRequest> {
    private final String webACLId;
    private final String changeToken;

    private DeleteWebACLRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.changeToken = builder.changeToken;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWebACLRequest)) {
            return false;
        }
        DeleteWebACLRequest other = (DeleteWebACLRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.webACLId() != null) {
            sb.append("WebACLId: ").append(this.webACLId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.of(clazz.cast(this.webACLId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String webACLId;
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWebACLRequest model) {
            this.webACLId(model.webACLId);
            this.changeToken(model.changeToken);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteWebACLRequest build() {
            return new DeleteWebACLRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, DeleteWebACLRequest> {
        public Builder webACLId(String var1);

        public Builder changeToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

