/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.waf.model.WAFRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateWebACLRequest
extends WAFRequest
implements ToCopyableBuilder<Builder, AssociateWebACLRequest> {
    private final String webACLId;
    private final String resourceArn;

    private AssociateWebACLRequest(BuilderImpl builder) {
        super(builder);
        this.webACLId = builder.webACLId;
        this.resourceArn = builder.resourceArn;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWebACLRequest)) {
            return false;
        }
        AssociateWebACLRequest other = (AssociateWebACLRequest)((Object)obj);
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.webACLId() != null) {
            sb.append("WebACLId: ").append(this.webACLId()).append(",");
        }
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.of(clazz.cast(this.webACLId()));
            }
            case "ResourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends WAFRequest.BuilderImpl
    implements Builder {
        private String webACLId;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWebACLRequest model) {
            this.webACLId(model.webACLId);
            this.resourceArn(model.resourceArn);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssociateWebACLRequest build() {
            return new AssociateWebACLRequest(this);
        }
    }

    public static interface Builder
    extends WAFRequest.Builder,
    CopyableBuilder<Builder, AssociateWebACLRequest> {
        public Builder webACLId(String var1);

        public Builder resourceArn(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

