/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.ByteMatchSet;

@SdkInternalApi
public class ByteMatchSetMarshaller {
    private static final MarshallingInfo<String> BYTEMATCHSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ByteMatchSetId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> BYTEMATCHTUPLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ByteMatchTuples").build();
    private static final ByteMatchSetMarshaller INSTANCE = new ByteMatchSetMarshaller();

    public static ByteMatchSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ByteMatchSet byteMatchSet, ProtocolMarshaller protocolMarshaller) {
        if (byteMatchSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)byteMatchSet.byteMatchSetId(), BYTEMATCHSETID_BINDING);
            protocolMarshaller.marshall((Object)byteMatchSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(byteMatchSet.byteMatchTuples(), BYTEMATCHTUPLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

