/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.services.waf.model.ActivatedRulesCopier;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.transform.WebACLMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebACL
implements StructuredPojo,
ToCopyableBuilder<Builder, WebACL> {
    private final String webACLId;
    private final String name;
    private final String metricName;
    private final WafAction defaultAction;
    private final List<ActivatedRule> rules;

    private WebACL(BuilderImpl builder) {
        this.webACLId = builder.webACLId;
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.defaultAction = builder.defaultAction;
        this.rules = builder.rules;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String name() {
        return this.name;
    }

    public String metricName() {
        return this.metricName;
    }

    public WafAction defaultAction() {
        return this.defaultAction;
    }

    public List<ActivatedRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACL)) {
            return false;
        }
        WebACL other = (WebACL)obj;
        return Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.defaultAction(), other.defaultAction()) && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.webACLId() != null) {
            sb.append("WebACLId: ").append(this.webACLId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.defaultAction() != null) {
            sb.append("DefaultAction: ").append(this.defaultAction()).append(",");
        }
        if (this.rules() != null) {
            sb.append("Rules: ").append(this.rules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebACLId": {
                return Optional.of(clazz.cast(this.webACLId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "DefaultAction": {
                return Optional.of(clazz.cast(this.defaultAction()));
            }
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebACLMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String webACLId;
        private String name;
        private String metricName;
        private WafAction defaultAction;
        private List<ActivatedRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACL model) {
            this.webACLId(model.webACLId);
            this.name(model.name);
            this.metricName(model.metricName);
            this.defaultAction(model.defaultAction);
            this.rules(model.rules);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final WafAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        @Override
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(WafAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        public final Collection<ActivatedRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(ActivatedRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<ActivatedRule> rules) {
            this.rules = ActivatedRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ActivatedRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public final void setRules(Collection<ActivatedRule.BuilderImpl> rules) {
            this.rules = ActivatedRulesCopier.copyFromBuilder(rules);
        }

        public WebACL build() {
            return new WebACL(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebACL> {
        public Builder webACLId(String var1);

        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder defaultAction(WafAction var1);

        default public Builder defaultAction(Consumer<WafAction.Builder> defaultAction) {
            return this.defaultAction((WafAction)((WafAction.Builder)WafAction.builder().apply(defaultAction)).build());
        }

        public Builder rules(Collection<ActivatedRule> var1);

        public Builder rules(ActivatedRule ... var1);
    }
}

