/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.GeoMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.GeoMatchSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGeoMatchSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListGeoMatchSetsResponse> {
    private final String nextMarker;
    private final List<GeoMatchSetSummary> geoMatchSets;

    private ListGeoMatchSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.geoMatchSets = builder.geoMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<GeoMatchSetSummary> geoMatchSets() {
        return this.geoMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoMatchSets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoMatchSetsResponse)) {
            return false;
        }
        ListGeoMatchSetsResponse other = (ListGeoMatchSetsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.geoMatchSets(), other.geoMatchSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.geoMatchSets() != null) {
            sb.append("GeoMatchSets: ").append(this.geoMatchSets()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "GeoMatchSets": {
                return Optional.of(clazz.cast(this.geoMatchSets()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<GeoMatchSetSummary> geoMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoMatchSetsResponse model) {
            this.nextMarker(model.nextMarker);
            this.geoMatchSets(model.geoMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<GeoMatchSetSummary.Builder> getGeoMatchSets() {
            return this.geoMatchSets != null ? (Collection)this.geoMatchSets.stream().map(GeoMatchSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder geoMatchSets(Collection<GeoMatchSetSummary> geoMatchSets) {
            this.geoMatchSets = GeoMatchSetSummariesCopier.copy(geoMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geoMatchSets(GeoMatchSetSummary ... geoMatchSets) {
            this.geoMatchSets(Arrays.asList(geoMatchSets));
            return this;
        }

        public final void setGeoMatchSets(Collection<GeoMatchSetSummary.BuilderImpl> geoMatchSets) {
            this.geoMatchSets = GeoMatchSetSummariesCopier.copyFromBuilder(geoMatchSets);
        }

        public ListGeoMatchSetsResponse build() {
            return new ListGeoMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListGeoMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder geoMatchSets(Collection<GeoMatchSetSummary> var1);

        public Builder geoMatchSets(GeoMatchSetSummary ... var1);
    }
}

