/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraintType;
import software.amazon.awssdk.services.waf.model.GeoMatchConstraintValue;
import software.amazon.awssdk.services.waf.transform.GeoMatchConstraintMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GeoMatchConstraint
implements StructuredPojo,
ToCopyableBuilder<Builder, GeoMatchConstraint> {
    private final String type;
    private final String value;

    private GeoMatchConstraint(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    public GeoMatchConstraintType type() {
        return GeoMatchConstraintType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public GeoMatchConstraintValue value() {
        return GeoMatchConstraintValue.fromValue(this.value);
    }

    public String valueString() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchConstraint)) {
            return false;
        }
        GeoMatchConstraint other = (GeoMatchConstraint)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.valueString(), other.valueString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.valueString() != null) {
            sb.append("Value: ").append(this.valueString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.valueString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeoMatchConstraintMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchConstraint model) {
            this.type(model.type);
            this.value(model.value);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GeoMatchConstraintType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public final Builder value(GeoMatchConstraintValue value) {
            this.value(value.toString());
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public GeoMatchConstraint build() {
            return new GeoMatchConstraint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GeoMatchConstraint> {
        public Builder type(String var1);

        public Builder type(GeoMatchConstraintType var1);

        public Builder value(String var1);

        public Builder value(GeoMatchConstraintValue var1);
    }
}

