/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteByteMatchSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteByteMatchSetRequest> {
    private final String byteMatchSetId;
    private final String changeToken;

    private DeleteByteMatchSetRequest(BuilderImpl builder) {
        this.byteMatchSetId = builder.byteMatchSetId;
        this.changeToken = builder.changeToken;
    }

    public String byteMatchSetId() {
        return this.byteMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteByteMatchSetRequest)) {
            return false;
        }
        DeleteByteMatchSetRequest other = (DeleteByteMatchSetRequest)((Object)obj);
        return Objects.equals(this.byteMatchSetId(), other.byteMatchSetId()) && Objects.equals(this.changeToken(), other.changeToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.byteMatchSetId() != null) {
            sb.append("ByteMatchSetId: ").append(this.byteMatchSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByteMatchSetId": {
                return Optional.of(clazz.cast(this.byteMatchSetId()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String byteMatchSetId;
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteByteMatchSetRequest model) {
            this.byteMatchSetId(model.byteMatchSetId);
            this.changeToken(model.changeToken);
        }

        public final String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public DeleteByteMatchSetRequest build() {
            return new DeleteByteMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteByteMatchSetRequest> {
        public Builder byteMatchSetId(String var1);

        public Builder changeToken(String var1);
    }
}

