/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.waf.model.GetWebACLRequest;
import software.amazon.awssdk.services.waf.transform.GetWebACLRequestModelMarshaller;

@SdkInternalApi
public class GetWebACLRequestMarshaller
implements Marshaller<Request<GetWebACLRequest>, GetWebACLRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSWAF_20150824.GetWebACL").serviceName("WAFClient").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public GetWebACLRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetWebACLRequest> marshall(GetWebACLRequest getWebACLRequest) {
        if (getWebACLRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (Object)getWebACLRequest);
            protocolMarshaller.startMarshalling();
            GetWebACLRequestModelMarshaller.getInstance().marshall(getWebACLRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

