/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.TextTransformation;
import software.amazon.awssdk.services.waf.transform.XssMatchTupleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class XssMatchTuple
implements StructuredPojo,
ToCopyableBuilder<Builder, XssMatchTuple> {
    private final FieldToMatch fieldToMatch;
    private final String textTransformation;

    private XssMatchTuple(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.textTransformation = builder.textTransformation;
    }

    public FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public TextTransformation textTransformation() {
        return TextTransformation.fromValue(this.textTransformation);
    }

    public String textTransformationString() {
        return this.textTransformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fieldToMatch() == null ? 0 : this.fieldToMatch().hashCode());
        hashCode = 31 * hashCode + (this.textTransformationString() == null ? 0 : this.textTransformationString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchTuple)) {
            return false;
        }
        XssMatchTuple other = (XssMatchTuple)obj;
        if (other.fieldToMatch() == null ^ this.fieldToMatch() == null) {
            return false;
        }
        if (other.fieldToMatch() != null && !other.fieldToMatch().equals(this.fieldToMatch())) {
            return false;
        }
        if (other.textTransformationString() == null ^ this.textTransformationString() == null) {
            return false;
        }
        return other.textTransformationString() == null || other.textTransformationString().equals(this.textTransformationString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.fieldToMatch() != null) {
            sb.append("FieldToMatch: ").append(this.fieldToMatch()).append(",");
        }
        if (this.textTransformationString() != null) {
            sb.append("TextTransformation: ").append(this.textTransformationString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.of(clazz.cast(this.fieldToMatch()));
            }
            case "TextTransformation": {
                return Optional.of(clazz.cast(this.textTransformationString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        XssMatchTupleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private String textTransformation;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchTuple model) {
            this.fieldToMatch(model.fieldToMatch);
            this.textTransformation(model.textTransformation);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final String getTextTransformation() {
            return this.textTransformation;
        }

        @Override
        public final Builder textTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
            return this;
        }

        @Override
        public final Builder textTransformation(TextTransformation textTransformation) {
            this.textTransformation(textTransformation.toString());
            return this;
        }

        public final void setTextTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
        }

        public XssMatchTuple build() {
            return new XssMatchTuple(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, XssMatchTuple> {
        public Builder fieldToMatch(FieldToMatch var1);

        public Builder textTransformation(String var1);

        public Builder textTransformation(TextTransformation var1);
    }
}

