/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.transform.WebACLUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebACLUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, WebACLUpdate> {
    private final String action;
    private final ActivatedRule activatedRule;

    private WebACLUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.activatedRule = builder.activatedRule;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public ActivatedRule activatedRule() {
        return this.activatedRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionString() == null ? 0 : this.actionString().hashCode());
        hashCode = 31 * hashCode + (this.activatedRule() == null ? 0 : this.activatedRule().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLUpdate)) {
            return false;
        }
        WebACLUpdate other = (WebACLUpdate)obj;
        if (other.actionString() == null ^ this.actionString() == null) {
            return false;
        }
        if (other.actionString() != null && !other.actionString().equals(this.actionString())) {
            return false;
        }
        if (other.activatedRule() == null ^ this.activatedRule() == null) {
            return false;
        }
        return other.activatedRule() == null || other.activatedRule().equals(this.activatedRule());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.activatedRule() != null) {
            sb.append("ActivatedRule: ").append(this.activatedRule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "ActivatedRule": {
                return Optional.of(clazz.cast(this.activatedRule()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebACLUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ActivatedRule activatedRule;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLUpdate model) {
            this.action(model.action);
            this.activatedRule(model.activatedRule);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ActivatedRule.Builder getActivatedRule() {
            return this.activatedRule != null ? this.activatedRule.toBuilder() : null;
        }

        @Override
        public final Builder activatedRule(ActivatedRule activatedRule) {
            this.activatedRule = activatedRule;
            return this;
        }

        public final void setActivatedRule(ActivatedRule.BuilderImpl activatedRule) {
            this.activatedRule = activatedRule != null ? activatedRule.build() : null;
        }

        public WebACLUpdate build() {
            return new WebACLUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebACLUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder activatedRule(ActivatedRule var1);
    }
}

