/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.ResourceArnsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourcesForWebACLResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListResourcesForWebACLResponse> {
    private final List<String> resourceArns;

    private ListResourcesForWebACLResponse(BuilderImpl builder) {
        this.resourceArns = builder.resourceArns;
    }

    public List<String> resourceArns() {
        return this.resourceArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceArns() == null ? 0 : this.resourceArns().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForWebACLResponse)) {
            return false;
        }
        ListResourcesForWebACLResponse other = (ListResourcesForWebACLResponse)((Object)obj);
        if (other.resourceArns() == null ^ this.resourceArns() == null) {
            return false;
        }
        return other.resourceArns() == null || other.resourceArns().equals(this.resourceArns());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceArns() != null) {
            sb.append("ResourceArns: ").append(this.resourceArns()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArns": {
                return Optional.of(clazz.cast(this.resourceArns()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> resourceArns;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForWebACLResponse model) {
            this.resourceArns(model.resourceArns);
        }

        public final Collection<String> getResourceArns() {
            return this.resourceArns;
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String ... resourceArns) {
            this.resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ResourceArnsCopier.copy(resourceArns);
        }

        public ListResourcesForWebACLResponse build() {
            return new ListResourcesForWebACLResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListResourcesForWebACLResponse> {
        public Builder resourceArns(Collection<String> var1);

        public Builder resourceArns(String ... var1);
    }
}

