/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.TimeWindow;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSampledRequestsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetSampledRequestsRequest> {
    private final String webAclId;
    private final String ruleId;
    private final TimeWindow timeWindow;
    private final Long maxItems;

    private GetSampledRequestsRequest(BuilderImpl builder) {
        this.webAclId = builder.webAclId;
        this.ruleId = builder.ruleId;
        this.timeWindow = builder.timeWindow;
        this.maxItems = builder.maxItems;
    }

    public String webAclId() {
        return this.webAclId;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public TimeWindow timeWindow() {
        return this.timeWindow;
    }

    public Long maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.webAclId() == null ? 0 : this.webAclId().hashCode());
        hashCode = 31 * hashCode + (this.ruleId() == null ? 0 : this.ruleId().hashCode());
        hashCode = 31 * hashCode + (this.timeWindow() == null ? 0 : this.timeWindow().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampledRequestsRequest)) {
            return false;
        }
        GetSampledRequestsRequest other = (GetSampledRequestsRequest)((Object)obj);
        if (other.webAclId() == null ^ this.webAclId() == null) {
            return false;
        }
        if (other.webAclId() != null && !other.webAclId().equals(this.webAclId())) {
            return false;
        }
        if (other.ruleId() == null ^ this.ruleId() == null) {
            return false;
        }
        if (other.ruleId() != null && !other.ruleId().equals(this.ruleId())) {
            return false;
        }
        if (other.timeWindow() == null ^ this.timeWindow() == null) {
            return false;
        }
        if (other.timeWindow() != null && !other.timeWindow().equals(this.timeWindow())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.webAclId() != null) {
            sb.append("WebAclId: ").append(this.webAclId()).append(",");
        }
        if (this.ruleId() != null) {
            sb.append("RuleId: ").append(this.ruleId()).append(",");
        }
        if (this.timeWindow() != null) {
            sb.append("TimeWindow: ").append(this.timeWindow()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebAclId": {
                return Optional.of(clazz.cast(this.webAclId()));
            }
            case "RuleId": {
                return Optional.of(clazz.cast(this.ruleId()));
            }
            case "TimeWindow": {
                return Optional.of(clazz.cast(this.timeWindow()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String webAclId;
        private String ruleId;
        private TimeWindow timeWindow;
        private Long maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampledRequestsRequest model) {
            this.webAclId(model.webAclId);
            this.ruleId(model.ruleId);
            this.timeWindow(model.timeWindow);
            this.maxItems(model.maxItems);
        }

        public final String getWebAclId() {
            return this.webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return this.timeWindow != null ? this.timeWindow.toBuilder() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        public final Long getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Long maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Long maxItems) {
            this.maxItems = maxItems;
        }

        public GetSampledRequestsRequest build() {
            return new GetSampledRequestsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetSampledRequestsRequest> {
        public Builder webAclId(String var1);

        public Builder ruleId(String var1);

        public Builder timeWindow(TimeWindow var1);

        public Builder maxItems(Long var1);
    }
}

