/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateWebACLRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateWebACLRequest> {
    private final String name;
    private final String metricName;
    private final WafAction defaultAction;
    private final String changeToken;

    private CreateWebACLRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.metricName = builder.metricName;
        this.defaultAction = builder.defaultAction;
        this.changeToken = builder.changeToken;
    }

    public String name() {
        return this.name;
    }

    public String metricName() {
        return this.metricName;
    }

    public WafAction defaultAction() {
        return this.defaultAction;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.defaultAction() == null ? 0 : this.defaultAction().hashCode());
        hashCode = 31 * hashCode + (this.changeToken() == null ? 0 : this.changeToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebACLRequest)) {
            return false;
        }
        CreateWebACLRequest other = (CreateWebACLRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.defaultAction() == null ^ this.defaultAction() == null) {
            return false;
        }
        if (other.defaultAction() != null && !other.defaultAction().equals(this.defaultAction())) {
            return false;
        }
        if (other.changeToken() == null ^ this.changeToken() == null) {
            return false;
        }
        return other.changeToken() == null || other.changeToken().equals(this.changeToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.defaultAction() != null) {
            sb.append("DefaultAction: ").append(this.defaultAction()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "DefaultAction": {
                return Optional.of(clazz.cast(this.defaultAction()));
            }
            case "ChangeToken": {
                return Optional.of(clazz.cast(this.changeToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String metricName;
        private WafAction defaultAction;
        private String changeToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebACLRequest model) {
            this.name(model.name);
            this.metricName(model.metricName);
            this.defaultAction(model.defaultAction);
            this.changeToken(model.changeToken);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final WafAction.Builder getDefaultAction() {
            return this.defaultAction != null ? this.defaultAction.toBuilder() : null;
        }

        @Override
        public final Builder defaultAction(WafAction defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(WafAction.BuilderImpl defaultAction) {
            this.defaultAction = defaultAction != null ? defaultAction.build() : null;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public CreateWebACLRequest build() {
            return new CreateWebACLRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateWebACLRequest> {
        public Builder name(String var1);

        public Builder metricName(String var1);

        public Builder defaultAction(WafAction var1);

        public Builder changeToken(String var1);
    }
}

