/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.transform.ByteMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ByteMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchSetUpdate> {
    private final String action;
    private final ByteMatchTuple byteMatchTuple;

    private ByteMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.byteMatchTuple = builder.byteMatchTuple;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public ByteMatchTuple byteMatchTuple() {
        return this.byteMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actionString() == null ? 0 : this.actionString().hashCode());
        hashCode = 31 * hashCode + (this.byteMatchTuple() == null ? 0 : this.byteMatchTuple().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSetUpdate)) {
            return false;
        }
        ByteMatchSetUpdate other = (ByteMatchSetUpdate)obj;
        if (other.actionString() == null ^ this.actionString() == null) {
            return false;
        }
        if (other.actionString() != null && !other.actionString().equals(this.actionString())) {
            return false;
        }
        if (other.byteMatchTuple() == null ^ this.byteMatchTuple() == null) {
            return false;
        }
        return other.byteMatchTuple() == null || other.byteMatchTuple().equals(this.byteMatchTuple());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.byteMatchTuple() != null) {
            sb.append("ByteMatchTuple: ").append(this.byteMatchTuple()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "ByteMatchTuple": {
                return Optional.of(clazz.cast(this.byteMatchTuple()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ByteMatchTuple byteMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSetUpdate model) {
            this.action(model.action);
            this.byteMatchTuple(model.byteMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ByteMatchTuple.Builder getByteMatchTuple() {
            return this.byteMatchTuple != null ? this.byteMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder byteMatchTuple(ByteMatchTuple byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple;
            return this;
        }

        public final void setByteMatchTuple(ByteMatchTuple.BuilderImpl byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple != null ? byteMatchTuple.build() : null;
        }

        public ByteMatchSetUpdate build() {
            return new ByteMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder byteMatchTuple(ByteMatchTuple var1);
    }
}

