/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.transform.ByteMatchSetSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ByteMatchSetSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchSetSummary> {
    private final String byteMatchSetId;
    private final String name;

    private ByteMatchSetSummary(BuilderImpl builder) {
        this.byteMatchSetId = builder.byteMatchSetId;
        this.name = builder.name;
    }

    public String byteMatchSetId() {
        return this.byteMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.byteMatchSetId() == null ? 0 : this.byteMatchSetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSetSummary)) {
            return false;
        }
        ByteMatchSetSummary other = (ByteMatchSetSummary)obj;
        if (other.byteMatchSetId() == null ^ this.byteMatchSetId() == null) {
            return false;
        }
        if (other.byteMatchSetId() != null && !other.byteMatchSetId().equals(this.byteMatchSetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.byteMatchSetId() != null) {
            sb.append("ByteMatchSetId: ").append(this.byteMatchSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByteMatchSetId": {
                return Optional.of(clazz.cast(this.byteMatchSetId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchSetSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String byteMatchSetId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSetSummary model) {
            this.byteMatchSetId(model.byteMatchSetId);
            this.name(model.name);
        }

        public final String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public ByteMatchSetSummary build() {
            return new ByteMatchSetSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchSetSummary> {
        public Builder byteMatchSetId(String var1);

        public Builder name(String var1);
    }
}

