/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.waf.model.XssMatchSetSummariesCopier;
import software.amazon.awssdk.services.waf.model.XssMatchSetSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListXssMatchSetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListXssMatchSetsResponse> {
    private final String nextMarker;
    private final List<XssMatchSetSummary> xssMatchSets;

    private ListXssMatchSetsResponse(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.xssMatchSets = builder.xssMatchSets;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<XssMatchSetSummary> xssMatchSets() {
        return this.xssMatchSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.xssMatchSets() == null ? 0 : this.xssMatchSets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListXssMatchSetsResponse)) {
            return false;
        }
        ListXssMatchSetsResponse other = (ListXssMatchSetsResponse)((Object)obj);
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.xssMatchSets() == null ^ this.xssMatchSets() == null) {
            return false;
        }
        return other.xssMatchSets() == null || other.xssMatchSets().equals(this.xssMatchSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.xssMatchSets() != null) {
            sb.append("XssMatchSets: ").append(this.xssMatchSets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<XssMatchSetSummary> xssMatchSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListXssMatchSetsResponse model) {
            this.setNextMarker(model.nextMarker);
            this.setXssMatchSets(model.xssMatchSets);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<XssMatchSetSummary> getXssMatchSets() {
            return this.xssMatchSets;
        }

        @Override
        public final Builder xssMatchSets(Collection<XssMatchSetSummary> xssMatchSets) {
            this.xssMatchSets = XssMatchSetSummariesCopier.copy(xssMatchSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xssMatchSets(XssMatchSetSummary ... xssMatchSets) {
            this.xssMatchSets(Arrays.asList(xssMatchSets));
            return this;
        }

        public final void setXssMatchSets(Collection<XssMatchSetSummary> xssMatchSets) {
            this.xssMatchSets = XssMatchSetSummariesCopier.copy(xssMatchSets);
        }

        public ListXssMatchSetsResponse build() {
            return new ListXssMatchSetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListXssMatchSetsResponse> {
        public Builder nextMarker(String var1);

        public Builder xssMatchSets(Collection<XssMatchSetSummary> var1);

        public Builder xssMatchSets(XssMatchSetSummary ... var1);
    }
}

