/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.Predicate;
import software.amazon.awssdk.services.waf.transform.RuleUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RuleUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, RuleUpdate> {
    private final String action;
    private final Predicate predicate;

    private RuleUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.predicate = builder.predicate;
    }

    public String action() {
        return this.action;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.predicate() == null ? 0 : this.predicate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleUpdate)) {
            return false;
        }
        RuleUpdate other = (RuleUpdate)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.predicate() == null ^ this.predicate() == null) {
            return false;
        }
        return other.predicate() == null || other.predicate().equals(this.predicate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.predicate() != null) {
            sb.append("Predicate: ").append(this.predicate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private Predicate predicate;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleUpdate model) {
            this.setAction(model.action);
            this.setPredicate(model.predicate);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Predicate getPredicate() {
            return this.predicate;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final void setPredicate(Predicate predicate) {
            this.predicate = predicate;
        }

        public RuleUpdate build() {
            return new RuleUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RuleUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder predicate(Predicate var1);
    }
}

