/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.SizeConstraintSet;

@SdkInternalApi
public class SizeConstraintSetMarshaller {
    private static final MarshallingInfo<String> SIZECONSTRAINTSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeConstraintSetId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> SIZECONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeConstraints").build();
    private static final SizeConstraintSetMarshaller instance = new SizeConstraintSetMarshaller();

    public static SizeConstraintSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(SizeConstraintSet sizeConstraintSet, ProtocolMarshaller protocolMarshaller) {
        if (sizeConstraintSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sizeConstraintSet.sizeConstraintSetId(), SIZECONSTRAINTSETID_BINDING);
            protocolMarshaller.marshall((Object)sizeConstraintSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(sizeConstraintSet.sizeConstraints(), SIZECONSTRAINTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

