/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.transform.WebACLSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebACLSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, WebACLSummary> {
    private final String webACLId;
    private final String name;

    private WebACLSummary(BuilderImpl builder) {
        this.webACLId = builder.webACLId;
        this.name = builder.name;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.webACLId() == null ? 0 : this.webACLId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLSummary)) {
            return false;
        }
        WebACLSummary other = (WebACLSummary)obj;
        if (other.webACLId() == null ^ this.webACLId() == null) {
            return false;
        }
        if (other.webACLId() != null && !other.webACLId().equals(this.webACLId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.webACLId() != null) {
            sb.append("WebACLId: ").append(this.webACLId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WebACLSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String webACLId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLSummary model) {
            this.setWebACLId(model.webACLId);
            this.setName(model.name);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public WebACLSummary build() {
            return new WebACLSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebACLSummary> {
        public Builder webACLId(String var1);

        public Builder name(String var1);
    }
}

