/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.services.waf.model.ParameterExceptionField;
import software.amazon.awssdk.services.waf.model.ParameterExceptionReason;
import software.amazon.awssdk.services.waf.model.WAFException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WAFInvalidParameterException
extends WAFException
implements ToCopyableBuilder<Builder, WAFInvalidParameterException> {
    private final String field;
    private final String parameter;
    private final String reason;

    private WAFInvalidParameterException(BuilderImpl builder) {
        super(builder.message);
        this.field = builder.field;
        this.parameter = builder.parameter;
        this.reason = builder.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String field() {
        return this.field;
    }

    public String parameter() {
        return this.parameter;
    }

    public String reason() {
        return this.reason;
    }

    private static final class BuilderImpl
    implements Builder {
        private String field;
        private String parameter;
        private String reason;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(WAFInvalidParameterException model) {
            this.setField(model.field);
            this.setParameter(model.parameter);
            this.setReason(model.reason);
            this.message = model.getMessage();
        }

        public final String getField() {
            return this.field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(ParameterExceptionField field) {
            this.field(field.toString());
            return this;
        }

        @JsonProperty(value="field")
        public final void setField(String field) {
            this.field = field;
        }

        public final void setField(ParameterExceptionField field) {
            this.field(field.toString());
        }

        public final String getParameter() {
            return this.parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        @JsonProperty(value="parameter")
        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ParameterExceptionReason reason) {
            this.reason(reason.toString());
            return this;
        }

        @JsonProperty(value="reason")
        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final void setReason(ParameterExceptionReason reason) {
            this.reason(reason.toString());
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public WAFInvalidParameterException build() {
            return new WAFInvalidParameterException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WAFInvalidParameterException> {
        public Builder field(String var1);

        public Builder field(ParameterExceptionField var1);

        public Builder parameter(String var1);

        public Builder reason(String var1);

        public Builder reason(ParameterExceptionReason var1);

        public Builder message(String var1);
    }
}

