/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.waf.model.XssMatchSetUpdate;
import software.amazon.awssdk.services.waf.model.XssMatchSetUpdatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateXssMatchSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateXssMatchSetRequest> {
    private final String xssMatchSetId;
    private final String changeToken;
    private final List<XssMatchSetUpdate> updates;

    private UpdateXssMatchSetRequest(BuilderImpl builder) {
        this.xssMatchSetId = builder.xssMatchSetId;
        this.changeToken = builder.changeToken;
        this.updates = builder.updates;
    }

    public String xssMatchSetId() {
        return this.xssMatchSetId;
    }

    public String changeToken() {
        return this.changeToken;
    }

    public List<XssMatchSetUpdate> updates() {
        return this.updates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.xssMatchSetId() == null ? 0 : this.xssMatchSetId().hashCode());
        hashCode = 31 * hashCode + (this.changeToken() == null ? 0 : this.changeToken().hashCode());
        hashCode = 31 * hashCode + (this.updates() == null ? 0 : this.updates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateXssMatchSetRequest)) {
            return false;
        }
        UpdateXssMatchSetRequest other = (UpdateXssMatchSetRequest)((Object)obj);
        if (other.xssMatchSetId() == null ^ this.xssMatchSetId() == null) {
            return false;
        }
        if (other.xssMatchSetId() != null && !other.xssMatchSetId().equals(this.xssMatchSetId())) {
            return false;
        }
        if (other.changeToken() == null ^ this.changeToken() == null) {
            return false;
        }
        if (other.changeToken() != null && !other.changeToken().equals(this.changeToken())) {
            return false;
        }
        if (other.updates() == null ^ this.updates() == null) {
            return false;
        }
        return other.updates() == null || other.updates().equals(this.updates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.xssMatchSetId() != null) {
            sb.append("XssMatchSetId: ").append(this.xssMatchSetId()).append(",");
        }
        if (this.changeToken() != null) {
            sb.append("ChangeToken: ").append(this.changeToken()).append(",");
        }
        if (this.updates() != null) {
            sb.append("Updates: ").append(this.updates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String xssMatchSetId;
        private String changeToken;
        private List<XssMatchSetUpdate> updates;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateXssMatchSetRequest model) {
            this.setXssMatchSetId(model.xssMatchSetId);
            this.setChangeToken(model.changeToken);
            this.setUpdates(model.updates);
        }

        public final String getXssMatchSetId() {
            return this.xssMatchSetId;
        }

        @Override
        public final Builder xssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
            return this;
        }

        public final void setXssMatchSetId(String xssMatchSetId) {
            this.xssMatchSetId = xssMatchSetId;
        }

        public final String getChangeToken() {
            return this.changeToken;
        }

        @Override
        public final Builder changeToken(String changeToken) {
            this.changeToken = changeToken;
            return this;
        }

        public final void setChangeToken(String changeToken) {
            this.changeToken = changeToken;
        }

        public final Collection<XssMatchSetUpdate> getUpdates() {
            return this.updates;
        }

        @Override
        public final Builder updates(Collection<XssMatchSetUpdate> updates) {
            this.updates = XssMatchSetUpdatesCopier.copy(updates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updates(XssMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
            return this;
        }

        public final void setUpdates(Collection<XssMatchSetUpdate> updates) {
            this.updates = XssMatchSetUpdatesCopier.copy(updates);
        }

        @SafeVarargs
        public final void setUpdates(XssMatchSetUpdate ... updates) {
            this.updates(Arrays.asList(updates));
        }

        public UpdateXssMatchSetRequest build() {
            return new UpdateXssMatchSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateXssMatchSetRequest> {
        public Builder xssMatchSetId(String var1);

        public Builder changeToken(String var1);

        public Builder updates(Collection<XssMatchSetUpdate> var1);

        public Builder updates(XssMatchSetUpdate ... var1);
    }
}

