/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.transform.ByteMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ByteMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchSetUpdate> {
    private final String action;
    private final ByteMatchTuple byteMatchTuple;

    private ByteMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.byteMatchTuple = builder.byteMatchTuple;
    }

    public String action() {
        return this.action;
    }

    public ByteMatchTuple byteMatchTuple() {
        return this.byteMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.byteMatchTuple() == null ? 0 : this.byteMatchTuple().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSetUpdate)) {
            return false;
        }
        ByteMatchSetUpdate other = (ByteMatchSetUpdate)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.byteMatchTuple() == null ^ this.byteMatchTuple() == null) {
            return false;
        }
        return other.byteMatchTuple() == null || other.byteMatchTuple().equals(this.byteMatchTuple());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.byteMatchTuple() != null) {
            sb.append("ByteMatchTuple: ").append(this.byteMatchTuple()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private ByteMatchTuple byteMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSetUpdate model) {
            this.setAction(model.action);
            this.setByteMatchTuple(model.byteMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final void setAction(ChangeAction action) {
            this.action(action.toString());
        }

        public final ByteMatchTuple getByteMatchTuple() {
            return this.byteMatchTuple;
        }

        @Override
        public final Builder byteMatchTuple(ByteMatchTuple byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple;
            return this;
        }

        public final void setByteMatchTuple(ByteMatchTuple byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple;
        }

        public ByteMatchSetUpdate build() {
            return new ByteMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder byteMatchTuple(ByteMatchTuple var1);
    }
}

