/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.model.ByteMatchTuplesCopier;
import software.amazon.awssdk.services.waf.transform.ByteMatchSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ByteMatchSet
implements StructuredPojo,
ToCopyableBuilder<Builder, ByteMatchSet> {
    private final String byteMatchSetId;
    private final String name;
    private final List<ByteMatchTuple> byteMatchTuples;

    private ByteMatchSet(BuilderImpl builder) {
        this.byteMatchSetId = builder.byteMatchSetId;
        this.name = builder.name;
        this.byteMatchTuples = builder.byteMatchTuples;
    }

    public String byteMatchSetId() {
        return this.byteMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<ByteMatchTuple> byteMatchTuples() {
        return this.byteMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.byteMatchSetId() == null ? 0 : this.byteMatchSetId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.byteMatchTuples() == null ? 0 : this.byteMatchTuples().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSet)) {
            return false;
        }
        ByteMatchSet other = (ByteMatchSet)obj;
        if (other.byteMatchSetId() == null ^ this.byteMatchSetId() == null) {
            return false;
        }
        if (other.byteMatchSetId() != null && !other.byteMatchSetId().equals(this.byteMatchSetId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.byteMatchTuples() == null ^ this.byteMatchTuples() == null) {
            return false;
        }
        return other.byteMatchTuples() == null || other.byteMatchTuples().equals(this.byteMatchTuples());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.byteMatchSetId() != null) {
            sb.append("ByteMatchSetId: ").append(this.byteMatchSetId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.byteMatchTuples() != null) {
            sb.append("ByteMatchTuples: ").append(this.byteMatchTuples()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String byteMatchSetId;
        private String name;
        private List<ByteMatchTuple> byteMatchTuples;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSet model) {
            this.setByteMatchSetId(model.byteMatchSetId);
            this.setName(model.name);
            this.setByteMatchTuples(model.byteMatchTuples);
        }

        public final String getByteMatchSetId() {
            return this.byteMatchSetId;
        }

        @Override
        public final Builder byteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
            return this;
        }

        public final void setByteMatchSetId(String byteMatchSetId) {
            this.byteMatchSetId = byteMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<ByteMatchTuple> getByteMatchTuples() {
            return this.byteMatchTuples;
        }

        @Override
        public final Builder byteMatchTuples(Collection<ByteMatchTuple> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copy(byteMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byteMatchTuples(ByteMatchTuple ... byteMatchTuples) {
            this.byteMatchTuples(Arrays.asList(byteMatchTuples));
            return this;
        }

        public final void setByteMatchTuples(Collection<ByteMatchTuple> byteMatchTuples) {
            this.byteMatchTuples = ByteMatchTuplesCopier.copy(byteMatchTuples);
        }

        @SafeVarargs
        public final void setByteMatchTuples(ByteMatchTuple ... byteMatchTuples) {
            this.byteMatchTuples(Arrays.asList(byteMatchTuples));
        }

        public ByteMatchSet build() {
            return new ByteMatchSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ByteMatchSet> {
        public Builder byteMatchSetId(String var1);

        public Builder name(String var1);

        public Builder byteMatchTuples(Collection<ByteMatchTuple> var1);

        public Builder byteMatchTuples(ByteMatchTuple ... var1);
    }
}

