/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateWebACLRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateWebACLRequest> {
    private final String webACLId;
    private final String resourceArn;

    private AssociateWebACLRequest(BuilderImpl builder) {
        this.webACLId = builder.webACLId;
        this.resourceArn = builder.resourceArn;
    }

    public String webACLId() {
        return this.webACLId;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.webACLId() == null ? 0 : this.webACLId().hashCode());
        hashCode = 31 * hashCode + (this.resourceArn() == null ? 0 : this.resourceArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWebACLRequest)) {
            return false;
        }
        AssociateWebACLRequest other = (AssociateWebACLRequest)((Object)obj);
        if (other.webACLId() == null ^ this.webACLId() == null) {
            return false;
        }
        if (other.webACLId() != null && !other.webACLId().equals(this.webACLId())) {
            return false;
        }
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        return other.resourceArn() == null || other.resourceArn().equals(this.resourceArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.webACLId() != null) {
            sb.append("WebACLId: ").append(this.webACLId()).append(",");
        }
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String webACLId;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWebACLRequest model) {
            this.setWebACLId(model.webACLId);
            this.setResourceArn(model.resourceArn);
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public AssociateWebACLRequest build() {
            return new AssociateWebACLRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateWebACLRequest> {
        public Builder webACLId(String var1);

        public Builder resourceArn(String var1);
    }
}

