/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.WafAction;
import software.amazon.awssdk.services.waf.model.WafRuleType;
import software.amazon.awssdk.services.waf.transform.ActivatedRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActivatedRule
implements StructuredPojo,
ToCopyableBuilder<Builder, ActivatedRule> {
    private final Integer priority;
    private final String ruleId;
    private final WafAction action;
    private final String type;

    private ActivatedRule(BuilderImpl builder) {
        this.priority = builder.priority;
        this.ruleId = builder.ruleId;
        this.action = builder.action;
        this.type = builder.type;
    }

    public Integer priority() {
        return this.priority;
    }

    public String ruleId() {
        return this.ruleId;
    }

    public WafAction action() {
        return this.action;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.ruleId() == null ? 0 : this.ruleId().hashCode());
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivatedRule)) {
            return false;
        }
        ActivatedRule other = (ActivatedRule)obj;
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.ruleId() == null ^ this.ruleId() == null) {
            return false;
        }
        if (other.ruleId() != null && !other.ruleId().equals(this.ruleId())) {
            return false;
        }
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        return other.type() == null || other.type().equals(this.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.ruleId() != null) {
            sb.append("RuleId: ").append(this.ruleId()).append(",");
        }
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivatedRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer priority;
        private String ruleId;
        private WafAction action;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivatedRule model) {
            this.setPriority(model.priority);
            this.setRuleId(model.ruleId);
            this.setAction(model.action);
            this.setType(model.type);
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        public final WafAction getAction() {
            return this.action;
        }

        @Override
        public final Builder action(WafAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(WafAction action) {
            this.action = action;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WafRuleType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(WafRuleType type) {
            this.type(type.toString());
        }

        public ActivatedRule build() {
            return new ActivatedRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActivatedRule> {
        public Builder priority(Integer var1);

        public Builder ruleId(String var1);

        public Builder action(WafAction var1);

        public Builder type(String var1);

        public Builder type(WafRuleType var1);
    }
}

