/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.SizeConstraintSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SizeConstraintSetMarshaller {
    private static final MarshallingInfo<String> SIZECONSTRAINTSETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeConstraintSetId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> SIZECONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeConstraints").isBinary(false).build();
    private static final SizeConstraintSetMarshaller INSTANCE = new SizeConstraintSetMarshaller();

    private SizeConstraintSetMarshaller() {
    }

    public static SizeConstraintSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SizeConstraintSet sizeConstraintSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sizeConstraintSet, (String)"sizeConstraintSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sizeConstraintSet.sizeConstraintSetId(), SIZECONSTRAINTSETID_BINDING);
            protocolMarshaller.marshall((Object)sizeConstraintSet.name(), NAME_BINDING);
            protocolMarshaller.marshall(sizeConstraintSet.sizeConstraints(), SIZECONSTRAINTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

