/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.RuleGroupUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RuleGroupUpdateMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTIVATEDRULE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivatedRule").isBinary(false).build();
    private static final RuleGroupUpdateMarshaller INSTANCE = new RuleGroupUpdateMarshaller();

    private RuleGroupUpdateMarshaller() {
    }

    public static RuleGroupUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RuleGroupUpdate ruleGroupUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ruleGroupUpdate, (String)"ruleGroupUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ruleGroupUpdate.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)ruleGroupUpdate.activatedRule(), ACTIVATEDRULE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

