/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.RuleGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RuleGroupMarshaller {
    private static final MarshallingInfo<String> RULEGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleGroupId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").isBinary(false).build();
    private static final RuleGroupMarshaller INSTANCE = new RuleGroupMarshaller();

    private RuleGroupMarshaller() {
    }

    public static RuleGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RuleGroup ruleGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ruleGroup, (String)"ruleGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ruleGroup.ruleGroupId(), RULEGROUPID_BINDING);
            protocolMarshaller.marshall((Object)ruleGroup.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)ruleGroup.metricName(), METRICNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

