/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.AssociateWebAclRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssociateWebAclRequestModelMarshaller {
    private static final MarshallingInfo<String> WEBACLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WebACLId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").isBinary(false).build();
    private static final AssociateWebAclRequestModelMarshaller INSTANCE = new AssociateWebAclRequestModelMarshaller();

    private AssociateWebAclRequestModelMarshaller() {
    }

    public static AssociateWebAclRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociateWebAclRequest associateWebAclRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)associateWebAclRequest), (String)"associateWebAclRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)associateWebAclRequest.webACLId(), WEBACLID_BINDING);
            protocolMarshaller.marshall((Object)associateWebAclRequest.resourceArn(), RESOURCEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

