/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ActivatedRuleMarshaller {
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").isBinary(false).build();
    private static final MarshallingInfo<String> RULEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuleId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OVERRIDEACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OverrideAction").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final ActivatedRuleMarshaller INSTANCE = new ActivatedRuleMarshaller();

    private ActivatedRuleMarshaller() {
    }

    public static ActivatedRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ActivatedRule activatedRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)activatedRule, (String)"activatedRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)activatedRule.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall((Object)activatedRule.ruleId(), RULEID_BINDING);
            protocolMarshaller.marshall((Object)activatedRule.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)activatedRule.overrideAction(), OVERRIDEACTION_BINDING);
            protocolMarshaller.marshall((Object)activatedRule.typeAsString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

