/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.XssMatchTuple;
import software.amazon.awssdk.services.waf.transform.XssMatchSetUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XssMatchSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, XssMatchSetUpdate> {
    private final String action;
    private final XssMatchTuple xssMatchTuple;

    private XssMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.xssMatchTuple = builder.xssMatchTuple;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public XssMatchTuple xssMatchTuple() {
        return this.xssMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xssMatchTuple());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XssMatchSetUpdate)) {
            return false;
        }
        XssMatchSetUpdate other = (XssMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.xssMatchTuple(), other.xssMatchTuple());
    }

    public String toString() {
        return ToString.builder((String)"XssMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("XssMatchTuple", (Object)this.xssMatchTuple()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "XssMatchTuple": {
                return Optional.ofNullable(clazz.cast(this.xssMatchTuple()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        XssMatchSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private XssMatchTuple xssMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(XssMatchSetUpdate model) {
            this.action(model.action);
            this.xssMatchTuple(model.xssMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final XssMatchTuple.Builder getXssMatchTuple() {
            return this.xssMatchTuple != null ? this.xssMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder xssMatchTuple(XssMatchTuple xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple;
            return this;
        }

        public final void setXssMatchTuple(XssMatchTuple.BuilderImpl xssMatchTuple) {
            this.xssMatchTuple = xssMatchTuple != null ? xssMatchTuple.build() : null;
        }

        public XssMatchSetUpdate build() {
            return new XssMatchSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, XssMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder xssMatchTuple(XssMatchTuple var1);

        default public Builder xssMatchTuple(Consumer<XssMatchTuple.Builder> xssMatchTuple) {
            return this.xssMatchTuple((XssMatchTuple)((XssMatchTuple.Builder)XssMatchTuple.builder().applyMutation(xssMatchTuple)).build());
        }
    }
}

