/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.transform.RuleGroupUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, RuleGroupUpdate> {
    private final String action;
    private final ActivatedRule activatedRule;

    private RuleGroupUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.activatedRule = builder.activatedRule;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public ActivatedRule activatedRule() {
        return this.activatedRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activatedRule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupUpdate)) {
            return false;
        }
        RuleGroupUpdate other = (RuleGroupUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.activatedRule(), other.activatedRule());
    }

    public String toString() {
        return ToString.builder((String)"RuleGroupUpdate").add("Action", (Object)this.actionAsString()).add("ActivatedRule", (Object)this.activatedRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "ActivatedRule": {
                return Optional.ofNullable(clazz.cast(this.activatedRule()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleGroupUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ActivatedRule activatedRule;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupUpdate model) {
            this.action(model.action);
            this.activatedRule(model.activatedRule);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ActivatedRule.Builder getActivatedRule() {
            return this.activatedRule != null ? this.activatedRule.toBuilder() : null;
        }

        @Override
        public final Builder activatedRule(ActivatedRule activatedRule) {
            this.activatedRule = activatedRule;
            return this;
        }

        public final void setActivatedRule(ActivatedRule.BuilderImpl activatedRule) {
            this.activatedRule = activatedRule != null ? activatedRule.build() : null;
        }

        public RuleGroupUpdate build() {
            return new RuleGroupUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RuleGroupUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder activatedRule(ActivatedRule var1);

        default public Builder activatedRule(Consumer<ActivatedRule.Builder> activatedRule) {
            return this.activatedRule((ActivatedRule)((ActivatedRule.Builder)ActivatedRule.builder().applyMutation(activatedRule)).build());
        }
    }
}

