/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.services.waf.transform.IPSetUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSetUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSetUpdate> {
    private final String action;
    private final IPSetDescriptor ipSetDescriptor;

    private IPSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.ipSetDescriptor = builder.ipSetDescriptor;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public IPSetDescriptor ipSetDescriptor() {
        return this.ipSetDescriptor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetDescriptor());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetUpdate)) {
            return false;
        }
        IPSetUpdate other = (IPSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.ipSetDescriptor(), other.ipSetDescriptor());
    }

    public String toString() {
        return ToString.builder((String)"IPSetUpdate").add("Action", (Object)this.actionAsString()).add("IPSetDescriptor", (Object)this.ipSetDescriptor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "IPSetDescriptor": {
                return Optional.ofNullable(clazz.cast(this.ipSetDescriptor()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private IPSetDescriptor ipSetDescriptor;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetUpdate model) {
            this.action(model.action);
            this.ipSetDescriptor(model.ipSetDescriptor);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final IPSetDescriptor.Builder getIPSetDescriptor() {
            return this.ipSetDescriptor != null ? this.ipSetDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder ipSetDescriptor(IPSetDescriptor ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor;
            return this;
        }

        public final void setIPSetDescriptor(IPSetDescriptor.BuilderImpl ipSetDescriptor) {
            this.ipSetDescriptor = ipSetDescriptor != null ? ipSetDescriptor.build() : null;
        }

        public IPSetUpdate build() {
            return new IPSetUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder ipSetDescriptor(IPSetDescriptor var1);

        default public Builder ipSetDescriptor(Consumer<IPSetDescriptor.Builder> ipSetDescriptor) {
            return this.ipSetDescriptor((IPSetDescriptor)((IPSetDescriptor.Builder)IPSetDescriptor.builder().applyMutation(ipSetDescriptor)).build());
        }
    }
}

