/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.IPSetDescriptorType;
import software.amazon.awssdk.services.waf.transform.IPSetDescriptorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSetDescriptor
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSetDescriptor> {
    private final String type;
    private final String value;

    private IPSetDescriptor(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    public IPSetDescriptorType type() {
        return IPSetDescriptorType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetDescriptor)) {
            return false;
        }
        IPSetDescriptor other = (IPSetDescriptor)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"IPSetDescriptor").add("Type", (Object)this.typeAsString()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetDescriptorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetDescriptor model) {
            this.type(model.type);
            this.value(model.value);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IPSetDescriptorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public IPSetDescriptor build() {
            return new IPSetDescriptor(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSetDescriptor> {
        public Builder type(String var1);

        public Builder type(IPSetDescriptorType var1);

        public Builder value(String var1);
    }
}

