/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.XssMatchSetUpdate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class XssMatchSetUpdateMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> XSSMATCHTUPLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XssMatchTuple").isBinary(false).build();
    private static final XssMatchSetUpdateMarshaller INSTANCE = new XssMatchSetUpdateMarshaller();

    private XssMatchSetUpdateMarshaller() {
    }

    public static XssMatchSetUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(XssMatchSetUpdate xssMatchSetUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)xssMatchSetUpdate, (String)"xssMatchSetUpdate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)xssMatchSetUpdate.actionAsString(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)xssMatchSetUpdate.xssMatchTuple(), XSSMATCHTUPLE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

