/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.SampledHTTPRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SampledHTTPRequestMarshaller {
    private static final MarshallingInfo<StructuredPojo> REQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Request").isBinary(false).build();
    private static final MarshallingInfo<Long> WEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Weight").isBinary(false).build();
    private static final MarshallingInfo<Instant> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").isBinary(false).build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").isBinary(false).build();
    private static final SampledHTTPRequestMarshaller INSTANCE = new SampledHTTPRequestMarshaller();

    private SampledHTTPRequestMarshaller() {
    }

    public static SampledHTTPRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SampledHTTPRequest sampledHTTPRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sampledHTTPRequest, (String)"sampledHTTPRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sampledHTTPRequest.request(), REQUEST_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.weight(), WEIGHT_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.timestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)sampledHTTPRequest.action(), ACTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

