/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.waf.model.GetChangeTokenStatusRequest;
import software.amazon.awssdk.services.waf.transform.GetChangeTokenStatusRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetChangeTokenStatusRequestMarshaller
implements Marshaller<Request<GetChangeTokenStatusRequest>, GetChangeTokenStatusRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSWAF_20150824.GetChangeTokenStatus").serviceName("WAF").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GetChangeTokenStatusRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetChangeTokenStatusRequest> marshall(GetChangeTokenStatusRequest getChangeTokenStatusRequest) {
        Validate.paramNotNull((Object)((Object)getChangeTokenStatusRequest), (String)"getChangeTokenStatusRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)getChangeTokenStatusRequest);
            protocolMarshaller.startMarshalling();
            GetChangeTokenStatusRequestModelMarshaller.getInstance().marshall(getChangeTokenStatusRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

