/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.waf.model.ParameterExceptionField;
import software.amazon.awssdk.services.waf.model.ParameterExceptionReason;
import software.amazon.awssdk.services.waf.model.WafException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WafInvalidParameterException
extends WafException
implements ToCopyableBuilder<Builder, WafInvalidParameterException> {
    private final String field;
    private final String parameter;
    private final String reason;

    private WafInvalidParameterException(BuilderImpl builder) {
        super(builder);
        this.field = builder.field;
        this.parameter = builder.parameter;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public ParameterExceptionField field() {
        return ParameterExceptionField.fromValue(this.field);
    }

    public String fieldAsString() {
        return this.field;
    }

    public String parameter() {
        return this.parameter;
    }

    public ParameterExceptionReason reason() {
        return ParameterExceptionReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    static final class BuilderImpl
    extends WafException.BuilderImpl
    implements Builder {
        private String field;
        private String parameter;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(WafInvalidParameterException model) {
            super(model);
            this.field(model.field);
            this.parameter(model.parameter);
            this.reason(model.reason);
        }

        public final String getField() {
            return this.field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        @Override
        public final Builder field(ParameterExceptionField field) {
            this.field(field.toString());
            return this;
        }

        @JsonProperty(value="field")
        public final void setField(String field) {
            this.field = field;
        }

        public final String getParameter() {
            return this.parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        @JsonProperty(value="parameter")
        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ParameterExceptionReason reason) {
            this.reason(reason.toString());
            return this;
        }

        @JsonProperty(value="reason")
        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public WafInvalidParameterException build() {
            return new WafInvalidParameterException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WafInvalidParameterException>,
    WafException.Builder {
        public Builder field(String var1);

        public Builder field(ParameterExceptionField var1);

        public Builder parameter(String var1);

        public Builder reason(String var1);

        public Builder reason(ParameterExceptionReason var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

