/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RegexPatternStringsCopier;
import software.amazon.awssdk.services.waf.transform.RegexPatternSetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegexPatternSet
implements StructuredPojo,
ToCopyableBuilder<Builder, RegexPatternSet> {
    private final String regexPatternSetId;
    private final String name;
    private final List<String> regexPatternStrings;

    private RegexPatternSet(BuilderImpl builder) {
        this.regexPatternSetId = builder.regexPatternSetId;
        this.name = builder.name;
        this.regexPatternStrings = builder.regexPatternStrings;
    }

    public String regexPatternSetId() {
        return this.regexPatternSetId;
    }

    public String name() {
        return this.name;
    }

    public List<String> regexPatternStrings() {
        return this.regexPatternStrings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexPatternStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSet)) {
            return false;
        }
        RegexPatternSet other = (RegexPatternSet)obj;
        return Objects.equals(this.regexPatternSetId(), other.regexPatternSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.regexPatternStrings(), other.regexPatternStrings());
    }

    public String toString() {
        return ToString.builder((String)"RegexPatternSet").add("RegexPatternSetId", (Object)this.regexPatternSetId()).add("Name", (Object)this.name()).add("RegexPatternStrings", this.regexPatternStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegexPatternSetId": {
                return Optional.ofNullable(clazz.cast(this.regexPatternSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RegexPatternStrings": {
                return Optional.ofNullable(clazz.cast(this.regexPatternStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegexPatternSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String regexPatternSetId;
        private String name;
        private List<String> regexPatternStrings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSet model) {
            this.regexPatternSetId(model.regexPatternSetId);
            this.name(model.name);
            this.regexPatternStrings(model.regexPatternStrings);
        }

        public final String getRegexPatternSetId() {
            return this.regexPatternSetId;
        }

        @Override
        public final Builder regexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
            return this;
        }

        public final void setRegexPatternSetId(String regexPatternSetId) {
            this.regexPatternSetId = regexPatternSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getRegexPatternStrings() {
            return this.regexPatternStrings;
        }

        @Override
        public final Builder regexPatternStrings(Collection<String> regexPatternStrings) {
            this.regexPatternStrings = RegexPatternStringsCopier.copy(regexPatternStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexPatternStrings(String ... regexPatternStrings) {
            this.regexPatternStrings(Arrays.asList(regexPatternStrings));
            return this;
        }

        public final void setRegexPatternStrings(Collection<String> regexPatternStrings) {
            this.regexPatternStrings = RegexPatternStringsCopier.copy(regexPatternStrings);
        }

        public RegexPatternSet build() {
            return new RegexPatternSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegexPatternSet> {
        public Builder regexPatternSetId(String var1);

        public Builder name(String var1);

        public Builder regexPatternStrings(Collection<String> var1);

        public Builder regexPatternStrings(String ... var1);
    }
}

