/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.RegexMatchTuple;
import software.amazon.awssdk.services.waf.model.RegexMatchTuplesCopier;
import software.amazon.awssdk.services.waf.transform.RegexMatchSetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegexMatchSet
implements StructuredPojo,
ToCopyableBuilder<Builder, RegexMatchSet> {
    private final String regexMatchSetId;
    private final String name;
    private final List<RegexMatchTuple> regexMatchTuples;

    private RegexMatchSet(BuilderImpl builder) {
        this.regexMatchSetId = builder.regexMatchSetId;
        this.name = builder.name;
        this.regexMatchTuples = builder.regexMatchTuples;
    }

    public String regexMatchSetId() {
        return this.regexMatchSetId;
    }

    public String name() {
        return this.name;
    }

    public List<RegexMatchTuple> regexMatchTuples() {
        return this.regexMatchTuples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regexMatchSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexMatchTuples());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexMatchSet)) {
            return false;
        }
        RegexMatchSet other = (RegexMatchSet)obj;
        return Objects.equals(this.regexMatchSetId(), other.regexMatchSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.regexMatchTuples(), other.regexMatchTuples());
    }

    public String toString() {
        return ToString.builder((String)"RegexMatchSet").add("RegexMatchSetId", (Object)this.regexMatchSetId()).add("Name", (Object)this.name()).add("RegexMatchTuples", this.regexMatchTuples()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegexMatchSetId": {
                return Optional.ofNullable(clazz.cast(this.regexMatchSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RegexMatchTuples": {
                return Optional.ofNullable(clazz.cast(this.regexMatchTuples()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegexMatchSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String regexMatchSetId;
        private String name;
        private List<RegexMatchTuple> regexMatchTuples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexMatchSet model) {
            this.regexMatchSetId(model.regexMatchSetId);
            this.name(model.name);
            this.regexMatchTuples(model.regexMatchTuples);
        }

        public final String getRegexMatchSetId() {
            return this.regexMatchSetId;
        }

        @Override
        public final Builder regexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
            return this;
        }

        public final void setRegexMatchSetId(String regexMatchSetId) {
            this.regexMatchSetId = regexMatchSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<RegexMatchTuple.Builder> getRegexMatchTuples() {
            return this.regexMatchTuples != null ? (Collection)this.regexMatchTuples.stream().map(RegexMatchTuple::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regexMatchTuples(Collection<RegexMatchTuple> regexMatchTuples) {
            this.regexMatchTuples = RegexMatchTuplesCopier.copy(regexMatchTuples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchTuples(RegexMatchTuple ... regexMatchTuples) {
            this.regexMatchTuples(Arrays.asList(regexMatchTuples));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexMatchTuples(Consumer<RegexMatchTuple.Builder> ... regexMatchTuples) {
            this.regexMatchTuples(Stream.of(regexMatchTuples).map(c -> (RegexMatchTuple)((RegexMatchTuple.Builder)RegexMatchTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRegexMatchTuples(Collection<RegexMatchTuple.BuilderImpl> regexMatchTuples) {
            this.regexMatchTuples = RegexMatchTuplesCopier.copyFromBuilder(regexMatchTuples);
        }

        public RegexMatchSet build() {
            return new RegexMatchSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegexMatchSet> {
        public Builder regexMatchSetId(String var1);

        public Builder name(String var1);

        public Builder regexMatchTuples(Collection<RegexMatchTuple> var1);

        public Builder regexMatchTuples(RegexMatchTuple ... var1);

        public Builder regexMatchTuples(Consumer<RegexMatchTuple.Builder> ... var1);
    }
}

