/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.model.PredicateType;
import software.amazon.awssdk.services.waf.transform.PredicateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Predicate
implements StructuredPojo,
ToCopyableBuilder<Builder, Predicate> {
    private final Boolean negated;
    private final String type;
    private final String dataId;

    private Predicate(BuilderImpl builder) {
        this.negated = builder.negated;
        this.type = builder.type;
        this.dataId = builder.dataId;
    }

    public Boolean negated() {
        return this.negated;
    }

    public PredicateType type() {
        return PredicateType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String dataId() {
        return this.dataId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.negated());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        return Objects.equals(this.negated(), other.negated()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.dataId(), other.dataId());
    }

    public String toString() {
        return ToString.builder((String)"Predicate").add("Negated", (Object)this.negated()).add("Type", (Object)this.typeAsString()).add("DataId", (Object)this.dataId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Negated": {
                return Optional.ofNullable(clazz.cast(this.negated()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DataId": {
                return Optional.ofNullable(clazz.cast(this.dataId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredicateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean negated;
        private String type;
        private String dataId;

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            this.negated(model.negated);
            this.type(model.type);
            this.dataId(model.dataId);
        }

        public final Boolean getNegated() {
            return this.negated;
        }

        @Override
        public final Builder negated(Boolean negated) {
            this.negated = negated;
            return this;
        }

        public final void setNegated(Boolean negated) {
            this.negated = negated;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PredicateType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDataId() {
            return this.dataId;
        }

        @Override
        public final Builder dataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        public final void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public Predicate build() {
            return new Predicate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Predicate> {
        public Builder negated(Boolean var1);

        public Builder type(String var1);

        public Builder type(PredicateType var1);

        public Builder dataId(String var1);
    }
}

