/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.waf.transform.IPSetSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSetSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSetSummary> {
    private final String ipSetId;
    private final String name;

    private IPSetSummary(BuilderImpl builder) {
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetSummary)) {
            return false;
        }
        IPSetSummary other = (IPSetSummary)obj;
        return Objects.equals(this.ipSetId(), other.ipSetId()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"IPSetSummary").add("IPSetId", (Object)this.ipSetId()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSetId": {
                return Optional.ofNullable(clazz.cast(this.ipSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipSetId;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetSummary model) {
            this.ipSetId(model.ipSetId);
            this.name(model.name);
        }

        public final String getIPSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIPSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public IPSetSummary build() {
            return new IPSetSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSetSummary> {
        public Builder ipSetId(String var1);

        public Builder name(String var1);
    }
}

