/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.IPSetDescriptor;
import software.amazon.awssdk.services.waf.model.IPSetDescriptorsCopier;
import software.amazon.awssdk.services.waf.transform.IPSetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSet
implements StructuredPojo,
ToCopyableBuilder<Builder, IPSet> {
    private final String ipSetId;
    private final String name;
    private final List<IPSetDescriptor> ipSetDescriptors;

    private IPSet(BuilderImpl builder) {
        this.ipSetId = builder.ipSetId;
        this.name = builder.name;
        this.ipSetDescriptors = builder.ipSetDescriptors;
    }

    public String ipSetId() {
        return this.ipSetId;
    }

    public String name() {
        return this.name;
    }

    public List<IPSetDescriptor> ipSetDescriptors() {
        return this.ipSetDescriptors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetDescriptors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSet)) {
            return false;
        }
        IPSet other = (IPSet)obj;
        return Objects.equals(this.ipSetId(), other.ipSetId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ipSetDescriptors(), other.ipSetDescriptors());
    }

    public String toString() {
        return ToString.builder((String)"IPSet").add("IPSetId", (Object)this.ipSetId()).add("Name", (Object)this.name()).add("IPSetDescriptors", this.ipSetDescriptors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSetId": {
                return Optional.ofNullable(clazz.cast(this.ipSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IPSetDescriptors": {
                return Optional.ofNullable(clazz.cast(this.ipSetDescriptors()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipSetId;
        private String name;
        private List<IPSetDescriptor> ipSetDescriptors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IPSet model) {
            this.ipSetId(model.ipSetId);
            this.name(model.name);
            this.ipSetDescriptors(model.ipSetDescriptors);
        }

        public final String getIPSetId() {
            return this.ipSetId;
        }

        @Override
        public final Builder ipSetId(String ipSetId) {
            this.ipSetId = ipSetId;
            return this;
        }

        public final void setIPSetId(String ipSetId) {
            this.ipSetId = ipSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<IPSetDescriptor.Builder> getIPSetDescriptors() {
            return this.ipSetDescriptors != null ? (Collection)this.ipSetDescriptors.stream().map(IPSetDescriptor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipSetDescriptors(Collection<IPSetDescriptor> ipSetDescriptors) {
            this.ipSetDescriptors = IPSetDescriptorsCopier.copy(ipSetDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSetDescriptors(IPSetDescriptor ... ipSetDescriptors) {
            this.ipSetDescriptors(Arrays.asList(ipSetDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSetDescriptors(Consumer<IPSetDescriptor.Builder> ... ipSetDescriptors) {
            this.ipSetDescriptors(Stream.of(ipSetDescriptors).map(c -> (IPSetDescriptor)((IPSetDescriptor.Builder)IPSetDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIPSetDescriptors(Collection<IPSetDescriptor.BuilderImpl> ipSetDescriptors) {
            this.ipSetDescriptors = IPSetDescriptorsCopier.copyFromBuilder(ipSetDescriptors);
        }

        public IPSet build() {
            return new IPSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IPSet> {
        public Builder ipSetId(String var1);

        public Builder name(String var1);

        public Builder ipSetDescriptors(Collection<IPSetDescriptor> var1);

        public Builder ipSetDescriptors(IPSetDescriptor ... var1);

        public Builder ipSetDescriptors(Consumer<IPSetDescriptor.Builder> ... var1);
    }
}

