/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafregional.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest;
import software.amazon.awssdk.services.waf.transform.GetByteMatchSetRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetByteMatchSetRequestMarshaller
implements Marshaller<Request<GetByteMatchSetRequest>, GetByteMatchSetRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSWAF_Regional_20161128.GetByteMatchSet").serviceName("WAF Regional").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public GetByteMatchSetRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetByteMatchSetRequest> marshall(GetByteMatchSetRequest getByteMatchSetRequest) {
        Validate.paramNotNull((Object)((Object)getByteMatchSetRequest), (String)"getByteMatchSetRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)getByteMatchSetRequest);
            protocolMarshaller.startMarshalling();
            GetByteMatchSetRequestModelMarshaller.getInstance().marshall(getByteMatchSetRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

