/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.waf.model.Predicate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PredicateMarshaller {
    private static final MarshallingInfo<Boolean> NEGATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Negated").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> DATAID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataId").isBinary(false).build();
    private static final PredicateMarshaller INSTANCE = new PredicateMarshaller();

    private PredicateMarshaller() {
    }

    public static PredicateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Predicate predicate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)predicate, (String)"predicate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)predicate.negated(), NEGATED_BINDING);
            protocolMarshaller.marshall((Object)predicate.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)predicate.dataId(), DATAID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

